﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using TwoCamWPF.Helpers;
using System.Reflection;

namespace TwoCamWPF.Settings
{
    class StartSettings : ISubSettings
    {
        public bool AutoRun { get; set; }
        public bool RunCollapsed { get; set; }
        public bool RunAndRecord { get; set; }
        public int RunDelay { get; set; }

        public StartSettings()
        {
            RunCollapsed = false;
            RunAndRecord = false;
            RunDelay = 0;
            AutoRun = Helpers.AutorunHelper.Enabled;
        }

        public void Write(XmlWriter output)
        {
            try
            {
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Сохранение параметров запуска");
                output.WriteStartElement("StartSettings", "");
                output.WriteElementString("RunCollapsed", RunCollapsed.ToString());
                output.WriteElementString("RunAndRecord", RunAndRecord.ToString());
                output.WriteElementString("RunDelay", RunDelay.ToString());
                output.WriteEndElement();
            }
            catch (Exception e)
            {
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Ошибка сохранения параметров запуска");
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), e.Message);
            }
        }
        public void Load(XmlNode node)
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Загрузка параметров запуска");
            foreach (XmlNode child in node.ChildNodes)
            {
                try
                {
                    switch (child.Name)
                    {
                        case "RunCollapsed":
                            RunCollapsed = Convert.ToBoolean(child.InnerXml);
                            break;
                        case "RunAndRecord":
                            RunAndRecord = Convert.ToBoolean(child.InnerXml);
                            break;
                        case "RunDelay":
                            RunDelay = Convert.ToInt32(child.InnerXml);
                            break;
                    }
                }
                catch (Exception e)
                {
                    Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "!!!Ошибка загрузки парамтеров запуска " + e.Message);
                    Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "На узле " + child.Name);
                }
            }

        }





        public void Save()
        {
            if (OnSave != null)
                OnSave(this);
        }

        public event Action<ISubSettings> OnSave;
    }
}
